<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductAttribute extends Model 
{

    protected $table = 'products_attributes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function products_allowed_attributes_values()
    {
        return $this->hasMany('App\Models\Product\ProductAttributeValue', 'product_attribute_id');
    }

    public function products_allowed_attributes()
    {
        return $this->hasMany('App\Models\Product\ProductAllowedAttribute', 'product_attribute_id');
    }

}